PROGRAM Parameters_and_Values_Synchronisation
VAR
i														: USINT	:= 0 ;
j														: UINT 	;
k, iTemp												: INT 	;
rTemp													: REAL  ;
Read_Special_Display_Registers							: ModbusRegistersFB ;
AlarmResetButton_PointSync_FB							: FB_registers_display_program_sync ; (* 1 instance for each point that can be changed from UI, remotely, AND by the internal m24 program *)
SyncPoint_FB											: FB_registers_display_sync ;
Set_Point_FB											: FB_registers_display_set ;
Check_New_Value_FB										: FB_limits_verification ;
OldProgramValues										: ARRAY[36..50] OF REAL ;
SaveRegistersTimer 										: INT 	:= 601 ;
END_VAR
IF StartupCounter=4 THEN															(* m24 is starting up; at StartupCountet=3, the values are loaded from the registers in the Startup Sequence *)
	FOR i:=36 TO 47 BY 1 DO 														(* go through all points the user can set *)
		OldProgramValues[i] := ProgramValues[i] ; 									(* make sure we don't trigger any saving of values upon startup --> values are first loaded in the "startup sequence" program *)
	END_FOR ;																		(* here we set those values as "previous itteration" values, so the initial values are not considered "new" when the startupcounter > 15 *)
	
	FOR i:=48 TO 50 BY 1 DO
		ProgramValues[i] := 0.0 ;
		Set_Point_FB(PointNR:=i) ;
	END_FOR ;
	
ELSIF module_ready THEN	

	Read_Special_Display_Registers (SlaveAddress:=DisplayAddress, StartRegister:=3000, RegisterCount:=9, RegisterType:=3, TimeOut:=300, PollInterval:=2000, Send:=0) ;
	IF (Read_Special_Display_Registers.DataValid=1) THEN
		iTemp := WORD_TO_INT(Read_Special_Display_Registers.REG8) + WORD_TO_INT(Read_Special_Display_Registers.REG7) ;
		Time_Schedule := BOOL_TO_INT(iTemp>=1) ;
	END_IF ;

	(* load values from the program to display points and local registers *)
	(* 1 and 2 are set in the startup sequence program *)
	ProgramValues[03] := INT_TO_REAL(AHU_status) ;
	ProgramValues[04] := Supply_Air_Temperature_Calculated_Setpoint * 10.0 ;
	ProgramValues[11] := Fresh_Air_Temperature_Measurement * 10.0 ; 
	ProgramValues[12] := Supply_Air_Temperature_Measurement * 10.0 ; 
	ProgramValues[13] := Return_Air_Temperature_Measurement * 10.0 ; 
	ProgramValues[14] := Return_Air_CO2_Measurement ; 
	ProgramValues[15] := Exhaust_Air_Temperature_Measurement * 10.0 ; 
	ProgramValues[16] := Heating_Coil_Return_Water_Temperature_Measurement *10.0 ; 	IF Fresh_Air_Damper_Position   	= OPENED 	THEN rTemp:=1.0; ELSE rTemp:=0.0; END_IF ;
	ProgramValues[17] := rTemp ; 													IF Exhaust_Air_Damper_Position 	= OPENED 	THEN rTemp:=1.0; ELSE rTemp:=0.0; END_IF ;
	ProgramValues[18] := rTemp ; 													IF Fresh_Air_Damper_Control	   	= OPEN		THEN rTemp:=1.0; ELSE rTemp:=0.0; END_IF ;
	ProgramValues[19] := rTemp ; 													IF Exhaust_Air_Damper_Control  	= OPEN		THEN rTemp:=1.0; ELSE rTemp:=0.0; END_IF ;
	ProgramValues[20] := rTemp ; 													IF Supply_Fan_Status		   	= RUNNING	THEN rTemp:=1.0; ELSE rTemp:=0.0; END_IF ;
	ProgramValues[21] := rTemp ;													IF Return_Fan_Status		   	= RUNNING	THEN rTemp:=1.0; ELSE rTemp:=0.0; END_IF ;
	ProgramValues[22] := rTemp ;													IF Supply_Fan_Command		   	= RUN		THEN rTemp:=1.0; ELSE rTemp:=0.0; END_IF ;
	ProgramValues[23] := rTemp ;													IF Return_Fan_Command		   	= RUN		THEN rTemp:=1.0; ELSE rTemp:=0.0; END_IF ;
	ProgramValues[24] := rTemp ;													
	ProgramValues[25] := Supply_Fan_Speed_Control ;													
	ProgramValues[26] := Return_Fan_Speed_Control ;									IF Fresh_Air_Filter			   	= DIRTY		THEN rTemp:=1.0; ELSE rTemp:=0.0; END_IF ;
	ProgramValues[27] := rTemp ;													IF Return_Air_Filter			= DIRTY		THEN rTemp:=1.0; ELSE rTemp:=0.0; END_IF ;
	ProgramValues[28] := rTemp ;													IF HRU_Control					= RUN		THEN rTemp:=1.0; ELSE rTemp:=0.0; END_IF ;												
	ProgramValues[29] := rTemp ;	
	ProgramValues[30] := HRU_Efficiency ;					  IF HRU_Action=HEATING THEN rTemp:=1.0;  ELSIF HRU_Action=COOLING 	THEN rTemp:=2.0; ELSE rTemp:=0.0; END_IF ;
	ProgramValues[31] := rTemp ;
	ProgramValues[32] := Heating_Coil_Valve_Control ; 
	ProgramValues[33] := Cooling_Coil_Valve_Control ; 								IF Cooling_Coil_Pump_Control	= RUN		THEN rTemp:=1.0; ELSE rTemp:=0.0; END_IF ;
	ProgramValues[34] := rTemp ; 
	(* 35 is set in the startup sequence program *)
	
	FOR i:=1 TO 35 BY 1 DO Set_Point_FB(PointNR:=i); END_FOR ;						(* write read-only values *)

	FOR i:=36 TO 49 BY 1 DO															(* read user-input / external master input values *)
		SyncPoint_FB (PointNR:=i) ;
		IF OldProgramValues[i]<>ProgramValues[i] THEN								(* if a value is changed *)
			IF i<48 THEN SaveRegistersTimer:=0;	END_IF ;							(* if it is a value we want to save, then reset timer if 1 of the values we want to save has changed *)
			k := USINT_TO_INT(i) ;
			Check_New_Value_FB (PointNR:=k) ;										(* verify if newly entered value is within limits *)
			IF Check_New_Value_FB.PointValue_Changed THEN							(* if the new value was out of limits and thus has been set to factory default or inside l *)
				Set_Point_FB (PointNR:=i) ;											(* send that updated value to display and registers *)
			END_IF ;
		END_IF ;
		OldProgramValues[i]:=ProgramValues[i]; 										(* save new value for next program itteration *)
	END_FOR ;	

	Heating_Coil_Valve_Manual_Control   				:= ProgramValues[36] ;
	Cooling_Coil_Valve_Manual_Control   				:= ProgramValues[37] ;
	Damper_Opening_Delay   				   := REAL_TO_DINT(ProgramValues[38] ) ;
	Fan_Conflict_Delay	   				   := REAL_TO_DINT(ProgramValues[39] ) ;
	Return_Air_CO2_Setpoint 							:= ProgramValues[40] ;
	Return_Air_Temperature_Setpoint 					:= ProgramValues[41] / 10.0 ;
	Supply_Air_Temperature_Setpoint_Minimum				:= ProgramValues[42] / 10.0 ;
	Supply_Air_Temperature_Setpoint_Maximum 			:= ProgramValues[43] / 10.0 ;
	Supply_Air_Temperature_Setpoint_Deviation_Limit 	:= ProgramValues[44] / 10.0 ;
	Heating_Coil_Return_Water_Temperature_Alarm_Limit 	:= ProgramValues[45] / 10.0 ;
	Heating_Coil_Return_Water_Temperature_Safety_P_Band := ProgramValues[46] / 10.0 ;
	Fans_Minimum_Start_Speed 							:= ProgramValues[47] ;
	Manual_Operation_Control 			   := REAL_TO_INT (ProgramValues[48] ) ;
	FireAlarm							   := REAL_TO_BOOL(ProgramValues[49] ) ;
	
	IF 		Alarm_Reset=17 		THEN rTemp:=17.0; 									(* reset button was pushed on the display *)
	ELSIF 	Alarm_Reset=0		THEN rTemp:= 0.0;									(* now we check if the Alarm_Reset variable value *)
	ELSIF	Alarm_Reset=1		THEN rTemp:= 1.0;									(* has been changed outside of this part of the program (= inside the main_AHU program) *)
	ELSE						 	 rTemp:= 0.0;									(* -- this option shouldn't be possible *)
	END_IF ;
	AlarmResetButton_PointSync_FB (PointNR:=50, New_Value:=rTemp) ;					(* The FB_registers_display_program_sync Function block makes changes possible from program, remote master (= internal m24 registers) and the display. Priority is given to the program running on the multi24 *)
	Alarm_Reset := REAL_TO_INT(ProgramValues[50]) ;									(* The FB_registers_display_program_sync Function block works on the ProgramValue array variables; now we set that (possiböy new) value to the actual local variable *)

	(* save registers that can be changed after 5 minutes of inactivity on those registers *)
	IF SaveRegistersTimer<600 THEN													(* if it is less than 5 minutes ago the last value was changed *)
		SaveRegistersTimer := SaveRegistersTimer + 1 ;								(* we keep counting untill is was 5 minutes *)
	ELSIF SaveRegistersTimer=600 THEN												(* 5 minutes after the last change of value by the user *)
		FOR i:=36 TO 47 BY 1 DO 													(* we go through all points the user can set and we want to save *)
			j := USINT_TO_UINT (i) ;
			iTemp := REAL_TO_INT(ProgramValues[i]) ;
			k := SetRegisterF (j, regValue:=INT_TO_WORD(iTemp)); 					(* and put all values into registers *)
		END_FOR ;	
		k := SaveRegistersF(1);														(* now we save all registers into the memory *)
		SaveRegistersTimer := SaveRegistersTimer + 1 ;								(* make sure we only save once -> memory has "# of writes" limit *)
	END_IF ;

END_IF ;
END_PROGRAM